define(['modules/new-appointment-request/tests/helpers/general-helper'], function(helpers) {
    'use strict';


    /**
     * Sample data
     * @return {[]}
     */
    function mockPatientFacility() {
        return [
            {
                'institution': {
                    'institutionCode': '631GC',
                    'name': 'PITTSFIELD CBOC',
                    'city': 'PITTSFIELD',
                    'stateAbbrev': 'MA',
                },
                'requestSupported': true,
                'directSchedulingSupported': true,
            },
            {
                'institution': {
                    'institutionCode': '631GD',
                    'name': 'GREENFIELD (CBOC)',
                    'city': 'GREENFIELD',
                    'stateAbbrev': 'MA',
                },
                'requestSupported': false,
                'directSchedulingSupported': false,
            },
            {
                'institution': {
                    'institutionCode': '631GE',
                    'name': 'WORCESTER CBOC',
                    'city': 'WORCESTER',
                    'stateAbbrev': 'MA',
                },
                'requestSupported': false,
                'directSchedulingSupported': true,
            },
        ];
    }


    return helpers._.extend({}, helpers, {mockPatientFacility: mockPatientFacility});
});
